<div class="content-wrapper">
          <!-- Content -->

          <div class="container-xxl flex-grow-1 container-p-y">
            <h4 class="py-0 mb-0"><span class="text-muted fw-light"></span> Customer and Employee Details</h4>
            <div class="row">
             <div class="row mb-4 g-3">
                <div class="col-xl-6">
                  <a href="<?php echo base_url('admin/register/customers');?>">
                    <div class="card">
                    <div class="card-body">
                      <div class="d-flex align-items-center justify-content-between">
                        <div class="content-left">
                          <h4 class="mb-0"><?=$users_count?></h4>
                          <small>Customers</small>
                        </div>
                        <span class="badge bg-label-primary rounded-circle p-2">
                          <!--<i class="ti ti-currency-dollar ti-md"></i>-->
                          <span class="material-symbols-outlined">
                            group
                            </span>
                        </span>
                      </div>
                    </div>
                  </div>
                  </a>
                </div>
                <div class="col-xl-6">
                    <a href="<?php echo base_url('admin/register/employees');?>">
                  <div class="card">
                    <div class="card-body">
                      <div class="d-flex align-items-center justify-content-between">
                        <div class="content-left">
                          <h4 class="mb-0"><?=$employees_count?></h4>
                          <small>Employees</small>
                        </div>
                        <span class="badge bg-label-success rounded-circle p-2">
                          <!--<i class="ti ti-gift ti-md"></i>-->
                          <span class="material-symbols-outlined">
                            group
                            </span>
                        </span>
                      </div>
                    </div>
                  </div>
                  </a>
                </div>
            
              </div>
            </div>
            
            
            <?php
            $get_customers = $this->registermodel->common_fetch_rows('users',array());
            $get_customers_active = $this->registermodel->common_fetch_rows('users',array('to_date >=' => date('Y-m-d')));
            $get_customers_inactive = $this->registermodel->common_fetch_rows('users',array('to_date <' => date('Y-m-d')));
            
            $get_employees = $this->registermodel->common_fetch_rows('employees',array('cat_id!=' => '','sub_cat_id!=' => '','mobile!=' => 0,'name!=' => '','profession!=' => '','exp!=' => '','engagement!=' => '','languages!=' => '','location!=' => '','gender!=' => '','delete_status' => 1)); 
            $get_employees_active = $this->registermodel->common_fetch_rows('employees',array('cat_id!=' => '','sub_cat_id!=' => '','mobile!=' => 0,'name!=' => '','profession!=' => '','exp!=' => '','engagement!=' => '','languages!=' => '','location!=' => '','gender!=' => '','delete_status' => 1,'status' => 1));
            $get_employees_inactive = $this->registermodel->common_fetch_rows('employees',array('cat_id!=' => '','sub_cat_id!=' => '','mobile!=' => 0,'name!=' => '','profession!=' => '','exp!=' => '','engagement!=' => '','languages!=' => '','location!=' => '','gender!=' => '','delete_status' => 1,'status' => 0));
                       
            ?>
            
            <div class="row">
             
              <!-- Donut Chart -->
             <div class="col-md-12 col-12 mt-4 mb-4 ">
              <div class="row">
                  
               <!--customers-->
               
                <div class="col-lg-6  mb-4">
                  <div class="card">
                    <div class="card-header d-flex align-items-center justify-content-between">
                      <div>
                        <h5 class="card-title mb-0">Customers</h5>
                        <!--<small class="text-muted">Spending on various categories</small>-->
                      </div>
                    </div>
                    <div class="card-body">
                      <div id="charts" ></div>
                    </div>
                  </div>
                </div>
            
                <script>
                var options = {
                    series: [<?=$get_customers?>, <?=$get_customers_active?>, <?=$get_customers_inactive?>],
                    labels:['Total Customers','Active Subscription','Inactive Subscription'],
            
                      chart: {
                      type: 'donut',
                      events: {
                        dataPointSelection: function(event, chartContext, config) {
                            // Get the index of the clicked segment
                            var dataPointIndex = config.dataPointIndex;
                            var label = config.w.config.labels[dataPointIndex];
                            //console.log(label);
                            
                            // Define URL mappings for each segment
                            var urlMappings = {
                                'Total Customers': 'register/customers',
                                'Active Subscription': 'register/active_customers',
                                'Inactive Subscription': 'register/inactive_customers'
                            };
    
                            // Redirect based on the label
                            if (urlMappings[label]) {
                                window.location.href = urlMappings[label];
                            }
                        }
                    }
                    },
                    responsive: [{
                      breakpoint: 480,
                      options: {
                        chart: {
                          width: 300
                        },
                        legend: {
                          position: 'bottom'
                        }
                      }
                    }]
                    };
        
                    var charts = new ApexCharts(document.querySelector("#charts"), options);
                    charts.render();
           </script>
                
            <!--customers-->
            
            
            <!--customers from selected city -->
                
                <div class="col-lg-6  mb-4">
                  <div class="card">
                    <div class="card-header d-flex align-items-center justify-content-between">
                      <div>
                        <h5 class="card-title mb-0">Customers From Selected City</h5>
                        <!--<small class="text-muted">Spending on various categories</small>-->
                      </div>
                    </div>
                    <div class="card-body">
                      <div id="customerselectedcity" ></div>
                    </div>
                  </div>
                </div>
                
                   <?php 
                        $i=0;
                        foreach($cities as $cities_row){
                            $get_cities = $this->registermodel->common_fetch_rows('users',['city_id' => $cities_row['id']]);
                            $city_arr[$i] = "'".$cities_row['name']."'";
                            $city_arrr[$i] = $get_cities;
                            $urlMappings_city[$cities_row['name']] = "register/city_users/" . $cities_row['id'];
                            $i++;
                        }//exit; 
                        
                        $city_imp = implode(",",$city_arr);
                        
                        $city_impp = implode(",",$city_arrr);
                        
                        $urlMappingsJson_city = json_encode($urlMappings_city);
                        
                        //echo $imp;exit;
                          ?>
               
                    <script>
                    var options = {
                          series: [<?=$city_impp?>],
                          labels:[<?=''.$city_imp.''?>],
                          chart: {
                          type: 'donut',
                          events: {
                            dataPointSelection: function(event, chartContext, config) {
                                // Get the index of the clicked segment
                                var dataPointIndex = config.dataPointIndex;
                                var label = config.w.config.labels[dataPointIndex];
                                //console.log(label);
                                
                                // Dynamic URL mappings passed from PHP
                                var urlMappings_city = JSON.parse('<?php echo $urlMappingsJson_city; ?>');
                                
                                // Redirect based on the label
                                if (urlMappings_city[label]) {
                                    window.location.href = urlMappings_city[label];
                                }
                            }
                        }
                        },
                        responsive: [{
                          breakpoint: 480,
                          options: {
                            chart: {
                              width: 300
                            },
                            legend: {
                              position: 'bottom'
                            }
                          }
                        }]
                        };
        
                var charts = new ApexCharts(document.querySelector("#customerselectedcity"), options);
                charts.render();
           </script>
                
                <!--customers from selected city -->
                
                
                
                <!--customers based on plans -->
                
                  <div class="col-lg-6  mb-4">
                  <div class="card">
                    <div class="card-header d-flex align-items-center justify-content-between">
                      <div>
                        <h5 class="card-title mb-0">Customers based on Subscription Plans</h5>
                        <!--<small class="text-muted">Spending on various categories</small>-->
                      </div>
                    </div>
                    <div class="card-body">
                      <div id="charts_data"> </div>
                    </div>
                  </div>
                </div>
           
                <?php 
                    $p=0;
                    foreach($subscriptions as $sub_row){
                        //print_r($sub_row);
                        $get_calls = $this->registermodel->common_fetch_rows('users',['subscription_id' => $sub_row['id']]);
                        $rr[$p] = "'".$sub_row['name']."'";
                        $rrr[$p] = $get_calls;
                        // Build URL mapping based on the subscription_id
                        $urlMappings_sub[$sub_row['name']] = "register/subscription_users/" . $sub_row['id'];
                        $p++;
                    }//exit; 
                    
                    
                    
                    $sub_imp = implode(",",$rr);
                    
                    $sub_impp = implode(",",$rrr);
                    
                    $urlMappingsJson_sub = json_encode($urlMappings_sub);
                    
                    //echo $imp;exit;
                  ?>
               
               <script>
                    var options = {
                           series: [<?=$sub_impp?>],
                           labels: [<?=''.$sub_imp.''?>],
                           chart: {
                           type: 'donut',
                           events: {
                            dataPointSelection: function(event, chartContext, config) {
                                // Get the index of the clicked segment
                                var dataPointIndex = config.dataPointIndex;
                                var label = config.w.config.labels[dataPointIndex];
                                //console.log(label);
                                
                                // Dynamic URL mappings passed from PHP
                                var urlMappings_sub = JSON.parse('<?php echo $urlMappingsJson_sub; ?>');
                                
                                // Redirect based on the label
                                if (urlMappings_sub[label]) {
                                    window.location.href = urlMappings_sub[label];
                                }
                            }
                        }
                        },
                        responsive: [{
                          breakpoint: 480,
                          options: {
                            chart: {
                              width: 300
                            },
                            legend: {
                              position: 'bottom'
                            }
                          }
                        }]
                        };
        
                    var charts = new ApexCharts(document.querySelector("#charts_data"), options);
                    charts.render();
               </script>
                
                <!--customers based on plans -->
                
                <!--customers revenue per month -->
                
                  <div class="col-lg-6  mb-4">
                  <div class="card">
                    <div class="card-header d-flex align-items-center justify-content-between">
                      <div>
                        <h5 class="card-title mb-0">Revenue Per Month</h5>
                        <!--<small class="text-muted">Spending on various categories</small>-->
                      </div>
                    </div>
                    <div class="card-body">
                      <div id="charts_revenue_data"> </div>
                    </div>
                  </div>
                </div>
           
               <?php 
                    $p=0;
                    //$sum=0;
                    foreach($months as $mon_row){
                        //print_r($sub_row);
                        $get_revenue = $this->registermodel->get_revenue($mon_row['id'],date('Y'));
                        if($get_revenue[0]['total_amount']!=0){
                            $sum = $get_revenue[0]['total_amount'];
                        }else{
                            $sum = 0;
                        }
                        $mon_rr[$p] = "'".$mon_row['name']."'";
                        $mon_rrr[$p] = $sum;
                        // Build URL mapping based on the subscription_id
                        $urlMappings_mon[$mon_row['name']] = "register/monthly_revenue/" . $mon_row['id'].'/'.date('Y');
                        $p++;
                    }//exit; 
                    
                    
                    
                    $mon_imp = implode(",",$mon_rr);
                    
                    $mon_impp = implode(",",$mon_rrr);
                    
                    $urlMappingsJson_mon = json_encode($urlMappings_mon);
                    
                    //echo $imp;exit;
                ?>
           
                <script>
                var options = {
                       series: [<?=$mon_impp?>],
                       labels: [<?=''.$mon_imp.''?>],
                      chart: {
                      type: 'donut',
                      events: {
                        dataPointSelection: function(event, chartContext, config) {
                            // Get the index of the clicked segment
                            var dataPointIndex = config.dataPointIndex;
                            var label = config.w.config.labels[dataPointIndex];
                            //console.log(label);
                            
                            // Dynamic URL mappings passed from PHP
                            var urlMappings_mon = JSON.parse('<?php echo $urlMappingsJson_mon; ?>');
                            
                            // Redirect based on the label
                            if (urlMappings_mon[label]) {
                                window.location.href = urlMappings_mon[label];
                            }
                        }
                    }
                    },
                    responsive: [{
                      breakpoint: 480,
                      options: {
                        chart: {
                          width: 300
                        },
                        legend: {
                          position: 'bottom'
                        }
                      }
                    }]
                    };
    
                var charts = new ApexCharts(document.querySelector("#charts_revenue_data"), options);
                charts.render();
           </script>
                
                <!--customers revenue per month -->
                
                <!--revenue from selected city -->
                
                <div class="col-lg-6  mb-4">
                  <div class="card">
                    <div class="card-header d-flex align-items-center justify-content-between">
                      <div>
                        <h5 class="card-title mb-0">Revenue From Selected City</h5>
                        <!--<small class="text-muted">Spending on various categories</small>-->
                      </div>
                    </div>
                    <div class="card-body">
                      <div id="revenueselectedcity" ></div>
                    </div>
                  </div>
                </div>
           
           <?php 
                $i=0;
                foreach($cities as $rev_cities_row){
                    $get_cities_rev = $this->registermodel->get_city_revenue($rev_cities_row['id'],date('Y'));
                    //echo $this->db->last_query();
                    $rev_city_arr[$i] = "'".$rev_cities_row['name']."'";
                    //$rev_city_arrr[$i] = $get_cities_rev;
                    if($get_cities_rev[0]['total_amount']!=0){
                        $sum = $get_cities_rev[0]['total_amount'];
                    }else{
                        $sum = 0;
                    }
                    $rev_city_arrr[$i] = $sum;
                    $urlMappings_rev_city[$rev_cities_row['name']] = "register/cities_rev/" . $rev_cities_row['id'];
                    $i++;
                }//exit; 
                
                $rev_city_imp = implode(",",$rev_city_arr);
                
                $rev_city_impp = implode(",",$rev_city_arrr);
                
                $urlMappingsJson_rev_city = json_encode($urlMappings_rev_city);
                
                //echo $imp;exit;
             ?>
           
           <script>
                var options = {
                       series: [<?=$total_revenue[0]['total_amount']?>,<?=$rev_city_impp?>],
                       labels:['Total Revenue(<?=date('Y')?>)',<?=''.$rev_city_imp.''?>],
                      chart: {
                      type: 'donut',
                      events: {
                        dataPointSelection: function(event, chartContext, config) {
                            // Get the index of the clicked segment
                            var dataPointIndex = config.dataPointIndex;
                            var label = config.w.config.labels[dataPointIndex];
                            //console.log(label);
                            
                            // Dynamic URL mappings passed from PHP
                            var urlMappings_rev_city = JSON.parse('<?php echo $urlMappingsJson_rev_city; ?>');
                            
                            // Redirect based on the label
                            if (urlMappings_rev_city[label]) {
                                window.location.href = urlMappings_rev_city[label];
                            }else{
                                window.location.href = '<?php echo base_url('admin/register/total_revenue');?>';
                            }
                        }
                    }
                    },
                    responsive: [{
                      breakpoint: 480,
                      options: {
                        chart: {
                          width: 300
                        },
                        legend: {
                          position: 'bottom'
                        }
                      }
                    }]
                    };
    
                var charts = new ApexCharts(document.querySelector("#revenueselectedcity"), options);
                charts.render();
           </script>
                
                <!--revenue from selected city -->
                
                
                <!--customer calls -->
                
                <div class="col-lg-6  mb-4">
                  <div class="card">
                    <div class="card-header d-flex align-items-center justify-content-between">
                      <div>
                        <h5 class="card-title mb-0">Calls based on Main Categories</h5>
                        <!--<small class="text-muted">Spending on various categories</small>-->
                      </div>
                    </div>
                    <div class="card-body">
                      <div id="customercallschart" ></div>
                    </div>
                  </div>
                </div>
                
                   <?php 
                    $i=0;
                    foreach($categories as $row){
                        $get_calls = $this->registermodel->common_fetch_rows('call_history',['cat_id' => $row['id']]);
                        $arr[$i] = "'".$row['name']."'";
                        $arrr[$i] = "".$get_calls."";
                        $urlMappings_cat_calls[$row['name']] = "register/cat_calls/" . $row['id'];
                        $i++;
                    }//exit; 
                    
                    $imp = implode(",",$arr);
                    
                    $impp = implode(",",$arrr);
                    
                    $urlMappingsJson_cat_calls = json_encode($urlMappings_cat_calls);
                    
                    //echo $imp;exit;
                      ?>
                   
                   <script>
                        var options = {
                   series: [<?=''.$impp.''?>],
                   labels:[<?=''.$imp.''?>],
                  chart: {
                  type: 'donut',
                  events: {
                        dataPointSelection: function(event, chartContext, config) {
                            // Get the index of the clicked segment
                            var dataPointIndex = config.dataPointIndex;
                            var label = config.w.config.labels[dataPointIndex];
                            //console.log(label);
                            
                            // Dynamic URL mappings passed from PHP
                            var urlMappings_cat_calls = JSON.parse('<?php echo $urlMappingsJson_cat_calls; ?>');
                            
                            // Redirect based on the label
                            if (urlMappings_cat_calls[label]) {
                                window.location.href = urlMappings_cat_calls[label];
                            }
                        }
                    }
                },
                responsive: [{
                  breakpoint: 480,
                  options: {
                    chart: {
                      width: 300
                    },
                    legend: {
                      position: 'bottom'
                    }
                  }
                }]
                };
        
                var charts = new ApexCharts(document.querySelector("#customercallschart"), options);
                charts.render();
           </script>
                
                <!--customer calls -->
                
                
                <!--customer calls Count-->
                
                <div class="col-lg-6  mb-4">
                  <div class="card">
                    <div class="card-header d-flex align-items-center justify-content-between">
                      <div>
                        <h5 class="card-title mb-0">Customer Calls</h5>
                        <!--<small class="text-muted">Spending on various categories</small>-->
                      </div>
                    </div>
                    <div class="card-body">
                      <div id="customercallcountchart" ></div>
                    </div>
                  </div>
                </div>
                
               <?php 
                    $p=0;
                    $sum1=0;
                    $sum2=0;
                    $sum3=0;
                    $sum4=0;
                    //foreach($users as $users_row){
                        //print_r($sub_row);
                        //$get_users_calls = $this->registermodel->common_fetch_rows('call_history',['user_id' => $users_row['id']]);
                        $get_users_calls_below20 = $this->registermodel->user_calls_below20_admin();
                        $get_users_calls_below30 = $this->registermodel->user_calls_below30_admin();
                        $get_users_calls_below40 = $this->registermodel->user_calls_below40_admin();
                        $get_users_calls_above40 = $this->registermodel->user_calls_above40_admin();
                        //echo '<pre>';
                        //echo $this->db->last_query();
                        if(!empty($get_users_calls_below20)){
                            //print_r($get_users_calls);
                            $sum1 = count($get_users_calls_below20);
                        }
                        if(!empty($get_users_calls_below30)){
                            //print_r($get_users_calls);
                            $sum2 = count($get_users_calls_below30);
                        }
                        if(!empty($get_users_calls_below40)){
                            //print_r($get_users_calls);
                            $sum3 = count($get_users_calls_below40);
                        }
                        if(!empty($get_users_calls_above40)){
                            //print_r($get_users_calls);
                            $sum4 = count($get_users_calls_above40);
                        }
                        //echo '</pre>';
                        //$users_rr[$p] = "'".$users_row['name']."'";
                        //$users_rrr[$p] = $get_users_calls;
                        // Build URL mapping based on the subscription_id
                        //$urlMappings_users[$users_row['name']] = "register/users_calls/" . $users_row['id'];
                        $p++;
                    //}//exit; 
                    
                    //echo $sum4;exit;
                    
                    
                    //$users_imp = implode(",",$users_rr);
                    
                    //$users_impp = implode(",",$users_rrr);
                    
                    //$urlMappingsJson_users = json_encode($urlMappings_users);
                    
                    //echo $imp;exit;
                  ?>
               
               <script>
                    var options = {
                           series: [<?=$sum1?>,<?=$sum2?>,<?=$sum3?>,<?=$sum4?>],
                           labels: ['0-20','20-30','30-40','>40'],
                          chart: {
                          type: 'donut',
                          events: {
                              dataPointSelection: function(event, chartContext, config) {
                                // Get the clicked label
                                var label = config.w.config.labels[config.dataPointIndex];
            
                                // Perform redirection based on the clicked label
                                if (label === '0-20') {
                                    window.location.href = '<?=base_url('admin/register/calls_below_20');?>';
                                } else if (label === '20-30') {
                                    window.location.href = '<?=base_url('admin/register/calls_below_30');?>';
                                } else if (label === '30-40') {
                                    window.location.href = '<?=base_url('admin/register/calls_below_40');?>';
                                } else if (label === '>40') {
                                    window.location.href = '<?=base_url('admin/register/calls_above_40');?>';
                                }
                            }
                          }
                        },
                        responsive: [{
                          breakpoint: 480,
                          options: {
                            chart: {
                              width: 300
                            },
                            legend: {
                              position: 'bottom'
                            }
                          }
                        }]
                        };
    
                    var charts = new ApexCharts(document.querySelector("#customercallcountchart"), options);
                    charts.render();
           </script>
        
                
                <!--customer calls Count-->
                
              </div>
             </div>
              <!-- /Donut Chart -->
            </div>
           
           
           <div class="row">
             
              <!-- Donut Chart -->
             <div class="col-md-12 col-12 mt-4 mb-4 ">
              <div class="row">
           
           <!--employees-->
                
                  <div class="col-lg-6  mb-4">
                  <div class="card">
                    <div class="card-header d-flex align-items-center justify-content-between">
                      <div>
                        <h5 class="card-title mb-0">Employees</h5>
                      </div>
                    </div>
                    <div class="card-body">
                      <div id="chart" ></div>
                    </div>
                  </div>
                </div>
            
                   <script>
                var options = {
                  series: [<?=$get_employees?>, <?=$get_employees_active?>, <?=$get_employees_inactive?>],
                  labels:['Employees','Active Employees','Inactive Employees'],
                  chart: {
                  type: 'donut',
                  events: {
                    dataPointSelection: function(event, chartContext, config) {
                        // Get the index of the clicked segment
                        var dataPointIndex = config.dataPointIndex;
                        var label = config.w.config.labels[dataPointIndex];
                        //console.log(label);
                        
                        // Define URL mappings for each segment
                        var urlMappings = {
                            'Employees': 'register/employees',
                            'Active Employees': 'register/active_employees',
                            'Inactive Employees': 'register/inactive_employees'
                        };
        
                        // Redirect based on the label
                        if (urlMappings[label]) {
                            window.location.href = urlMappings[label];
                        }
                    }
                }
                },
                responsive: [{
                  breakpoint: 480,
                  options: {
                    chart: {
                      width: 300
                    },
                    legend: {
                      position: 'bottom'
                    }
                  }
                }]
                };
        
                var chart = new ApexCharts(document.querySelector("#chart"), options);
                chart.render();
           </script>
                
           <!--employees-->
           
           
           <!--employees based on L1 Categories-->
                
                  <div class="col-lg-6  mb-4">
                  <div class="card">
                    <div class="card-header d-flex align-items-center justify-content-between">
                      <div>
                        <h5 class="card-title mb-0">Employees based on L1 Category</h5>
                      </div>
                    </div>
                    <div class="card-body">
                      <div id="chartemployeel1cat" ></div>
                    </div>
                  </div>
                </div>
            <?php
                $i=0;
                foreach($categories as $cate_row){
                    $get_emp = $this->registermodel->common_fetch_rows('employees',['cat_id' => $cate_row['id'],'mobile!=' => 0,'name!=' => '','profession!=' => '','exp!=' => '','engagement!=' => '','languages!=' => '','location!=' => '','gender!=' => '','delete_status' => 1]);
                    $cate_arr[$i] = "'".$cate_row['name']."'";
                    $cate_arrr[$i] = $get_emp;
                    $urlMappings_cat[$cate_row['name']] = "register/category_employees/" . base64_encode($cate_row['id']);
                    $i++;
                }//exit; 
                
                $cat_imp = implode(",",$cate_arr);
                
                $cat_impp = implode(",",$cate_arrr);
                
                $urlMappingsJson_cat = json_encode($urlMappings_cat);
                
                //echo $imp;exit;
            ?>
           
           <script>
                var options = {
                   series: [<?=$cat_impp?>],
                   labels:[<?=''.$cat_imp.''?>],
                  chart: {
                  type: 'donut',
                  events: {
                    dataPointSelection: function(event, chartContext, config) {
                        // Get the index of the clicked segment
                        var dataPointIndex = config.dataPointIndex;
                        var label = config.w.config.labels[dataPointIndex];
                        //console.log(label);
                        
                        // Dynamic URL mappings passed from PHP
                        var urlMappings_cat = JSON.parse('<?php echo $urlMappingsJson_cat; ?>');
                        
                        // Redirect based on the label
                        if (urlMappings_cat[label]) {
                            window.location.href = urlMappings_cat[label];
                        }
                    }
                }
                },
                responsive: [{
                  breakpoint: 480,
                  options: {
                    chart: {
                      width: 300
                    },
                    legend: {
                      position: 'bottom'
                    }
                  }
                }]
                };
        
                var charts = new ApexCharts(document.querySelector("#chartemployeel1cat"), options);
                charts.render();
           </script>
                
           <!--employees based on L1 Categories-->
           
           
           <!--employees based on L2 Categories-->
                
                  <div class="col-lg-6  mb-4">
                  <div class="card">
                    <div class="card-header d-flex align-items-center justify-content-between">
                      <div>
                        <h5 class="card-title mb-0">Employees based on L2 Category</h5>
                      </div>
                    </div>
                    <div class="card-body">
                      <div id="chartemployeel2cat" ></div>
                    </div>
                  </div>
                </div>
                
                    <?php
                    $i=0;
                    foreach($sub_categories as $sub_cate_row){
                        $get_sub_emp = $this->registermodel->common_fetch_rows('employees',['sub_cat_id' => $sub_cate_row['id'],'mobile!=' => 0,'name!=' => '','profession!=' => '','exp!=' => '','engagement!=' => '','languages!=' => '','location!=' => '','gender!=' => '','delete_status' => 1]);
                        $sub_cate_arr[$i] = "'".$sub_cate_row['name']."'";
                        $sub_cate_arrr[$i] = $get_sub_emp;
                        $urlMappings_sub_cat[$sub_cate_row['name']] = "register/sub_category_employees/" . base64_encode($sub_cate_row['id']);
                        $i++;
                    }//exit; 
                    
                    $sub_cat_imp = implode(",",$sub_cate_arr);
                    
                    $sub_cat_impp = implode(",",$sub_cate_arrr);
                    
                    $urlMappingsJson_sub_cat = json_encode($urlMappings_sub_cat);
                    
                    //echo $imp;exit;
                    ?>
                   
                   <script>
                        var options = {
                           series: [<?=$sub_cat_impp?>],
                           labels:[<?=''.$sub_cat_imp.''?>],
                          chart: {
                          type: 'donut',
                          events: {
                            dataPointSelection: function(event, chartContext, config) {
                                // Get the index of the clicked segment
                                var dataPointIndex = config.dataPointIndex;
                                var label = config.w.config.labels[dataPointIndex];
                                //console.log(label);
                                
                                // Dynamic URL mappings passed from PHP
                                var urlMappings_sub_cat = JSON.parse('<?php echo $urlMappingsJson_sub_cat; ?>');
                                
                                // Redirect based on the label
                                if (urlMappings_sub_cat[label]) {
                                    window.location.href = urlMappings_sub_cat[label];
                                }
                            }
                        }
                        },
                        responsive: [{
                          breakpoint: 480,
                          options: {
                            chart: {
                              width: 300
                            },
                            legend: {
                              position: 'bottom'
                            }
                          }
                        }]
                        };
                
                        var charts = new ApexCharts(document.querySelector("#chartemployeel2cat"), options);
                        charts.render();
                   </script>
                
           <!--employees based on L2 Categories-->
           
           <!--employees based on Nativity-->
                
                  <div class="col-lg-6  mb-4">
                  <div class="card">
                    <div class="card-header d-flex align-items-center justify-content-between">
                      <div>
                        <h5 class="card-title mb-0">Employees based on Nativity</h5>
                      </div>
                    </div>
                    <div class="card-body">
                      <div id="chartemployeenativity" ></div>
                    </div>
                  </div>
                </div>
                
                    <?php
                    $i=0;
                    foreach($nativity as $nativity_row){
                        $get_nativity_emp = $this->registermodel->common_fetch_rows('employees',['nativity' => $nativity_row['id'],'mobile!=' => 0,'name!=' => '','profession!=' => '','exp!=' => '','engagement!=' => '','languages!=' => '','location!=' => '','gender!=' => '','delete_status' => 1]);
                        $nativity_arr[$i] = "'".$nativity_row['name']."'";
                        $nativity_arrr[$i] = $get_nativity_emp;
                        $urlMappings_nativity[$nativity_row['name']] = "register/nativity_employees/" . base64_encode($nativity_row['id']);
                        $i++;
                    }//exit; 
                    
                    $nativity_imp = implode(",",$nativity_arr);
                    
                    $nativity_impp = implode(",",$nativity_arrr);
                    
                    $urlMappingsJson_nativity = json_encode($urlMappings_nativity);
                    
                    //echo $imp;exit;
                    ?>
                   
                   <script>
                        var options = {
                           series: [<?=$nativity_impp?>],
                           labels:[<?=''.$nativity_imp.''?>],
                          chart: {
                          type: 'donut',
                          events: {
                            dataPointSelection: function(event, chartContext, config) {
                                // Get the index of the clicked segment
                                var dataPointIndex = config.dataPointIndex;
                                var label = config.w.config.labels[dataPointIndex];
                                //console.log(label);
                                
                                // Dynamic URL mappings passed from PHP
                                var urlMappings_nativity = JSON.parse('<?php echo $urlMappingsJson_nativity; ?>');
                                
                                // Redirect based on the label
                                if (urlMappings_nativity[label]) {
                                    window.location.href = urlMappings_nativity[label];
                                }
                            }
                        }
                        },
                        responsive: [{
                          breakpoint: 480,
                          options: {
                            chart: {
                              width: 300
                            },
                            legend: {
                              position: 'bottom'
                            }
                          }
                        }]
                        };
                
                        var charts = new ApexCharts(document.querySelector("#chartemployeenativity"), options);
                        charts.render();
                   </script>
                
           <!--employees based on Nativity-->
           
           
           <!--employees based on Ratings-->
                
                  <div class="col-lg-6  mb-4">
                  <div class="card">
                    <div class="card-header d-flex align-items-center justify-content-between">
                      <div>
                        <h5 class="card-title mb-0">Employees based on Ratings</h5>
                      </div>
                    </div>
                    <div class="card-body">
                      <div id="chartemployeerating" ></div>
                    </div>
                  </div>
                </div>
                
                    <?php
                        $get_emp_exp_below_3 = $this->registermodel->emp_exp_below_3();
                        $get_emp_exp_below_4 = $this->registermodel->emp_exp_below_4();
                        $get_emp_exp_above_4 = $this->registermodel->emp_exp_above_4();
                    
                    ?>
                   
                   <script>
                        var options = {
                           series: [<?=count($get_emp_exp_below_3)?>,<?=count($get_emp_exp_below_4)?>,<?=count($get_emp_exp_above_4)?>],
                           labels:['2-3','3-4','>4'],
                          chart: {
                          type: 'donut',
                          events: {
                              dataPointSelection: function(event, chartContext, config) {
                                // Get the clicked label
                                var label = config.w.config.labels[config.dataPointIndex];
            
                                // Perform redirection based on the clicked label
                                if (label === '2-3') {
                                    window.location.href = '<?=base_url('admin/register/emp_exp_below_3');?>';
                                } else if (label === '3-4') {
                                    window.location.href = '<?=base_url('admin/register/emp_exp_below_4');?>';
                                } else if (label === '>4') {
                                    window.location.href = '<?=base_url('admin/register/emp_exp_above_4');?>';
                                }
                            }
                          }
                          
                        },
                        responsive: [{
                          breakpoint: 480,
                          options: {
                            chart: {
                              width: 300
                            },
                            legend: {
                              position: 'bottom'
                            }
                          }
                        }]
                        };
                
                        var charts = new ApexCharts(document.querySelector("#chartemployeerating"), options);
                        charts.render();
                   </script>
                
           <!--employees based on Ratings-->
           
           
           <!--review based employees-->
                
                  <!--<div class="col-lg-6  mb-4">
                  <div class="card">
                    <div class="card-header d-flex align-items-center justify-content-between">
                      <div>
                        <h5 class="card-title mb-0">Review based Employees</h5>
                      </div>
                    </div>
                    <div class="card-body">
                      <div id="chartreviewemployee" ></div>
                    </div>
                  </div>
                </div>-->
                
                    <?php
                    $i=0;
                    foreach($sub_categories as $sub_cate_row){
                        $get_sub_emp = $this->registermodel->common_fetch_rows('employees',['sub_cat_id' => $sub_cate_row['id'],'mobile!=' => 0,'name!=' => '','profession!=' => '','exp!=' => '','engagement!=' => '','languages!=' => '','location!=' => '','gender!=' => '','delete_status' => 1]);
                        $sub_cate_arr[$i] = "'".$sub_cate_row['name']."'";
                        $sub_cate_arrr[$i] = $get_sub_emp;
                        $urlMappings_sub_cat[$sub_cate_row['name']] = "register/sub_category_employees/" . $sub_cate_row['id'];
                        $i++;
                    }//exit; 
                    
                    $sub_cat_imp = implode(",",$sub_cate_arr);
                    
                    $sub_cat_impp = implode(",",$sub_cate_arrr);
                    
                    $urlMappingsJson_sub_cat = json_encode($urlMappings_sub_cat);
                    
                    //echo $imp;exit;
                    ?>
                   
                   <script>
                        var options = {
                           series: [<?=$sub_cat_impp?>],
                           labels:[<?=''.$sub_cat_imp.''?>],
                          chart: {
                          type: 'donut',
                          events: {
                            dataPointSelection: function(event, chartContext, config) {
                                // Get the index of the clicked segment
                                var dataPointIndex = config.dataPointIndex;
                                var label = config.w.config.labels[dataPointIndex];
                                //console.log(label);
                                
                                // Dynamic URL mappings passed from PHP
                                var urlMappings_sub_cat = JSON.parse('<?php echo $urlMappingsJson_sub_cat; ?>');
                                
                                // Redirect based on the label
                                if (urlMappings_sub_cat[label]) {
                                    window.location.href = urlMappings_sub_cat[label];
                                }
                            }
                        }
                        },
                        responsive: [{
                          breakpoint: 480,
                          options: {
                            chart: {
                              width: 300
                            },
                            legend: {
                              position: 'bottom'
                            }
                          }
                        }]
                        };
                
                        var charts = new ApexCharts(document.querySelector("#chartreviewemployee"), options);
                        charts.render();
                   </script>
                
           <!--review based employees-->
           
           </div>
             </div>
              <!-- /Donut Chart -->
            </div>
            
            <h4>Customers</h4>
            
            
            <div class="row mb-4 g-3">
                <div class="col-xl-4">
                    <a href="<?php echo base_url('admin/register/customers');?>">
                  <div class="card">
                    <div class="card-body">
                      <div class="d-flex align-items-center justify-content-between">
                        <div class="content-left">
                          <h4 class="mb-0"><?=$get_customers?></h4>
                          <small>Customers</small>
                        </div>
                        <span class="badge bg-label-primary rounded-circle p-2">
                          <!--<i class="ti ti-currency-dollar ti-md"></i>-->
                          <span class="material-symbols-outlined">
                                group
                            </span>
                        </span>
                      </div>
                    </div>
                  </div>
                  </a>
                </div>
                <div class="col-xl-4">
                <a href="<?php echo base_url('admin/register/active_customers');?>">
                  <div class="card">
                    <div class="card-body">
                      <div class="d-flex align-items-center justify-content-between">
                        <div class="content-left">
                          <h4 class="mb-0"><?=$get_customers_active?></h4>
                          <small>Active Subscription </small>
                        </div>
                        <span class="badge bg-label-success rounded-circle p-2">
                          <!--<i class="ti ti-gift ti-md"></i>-->
                         <span class="material-symbols-outlined ">
                        unknown_document
                        </span>
                        </span>
                      </div>
                    </div>
                  </div>
                  </a>
                </div>
                <div class="col-xl-4">
                    <a href="<?php echo base_url('admin/register/inactive_customers');?>">
                  <div class="card">
                    <div class="card-body">
                      <div class="d-flex align-items-center justify-content-between">
                        <div class="content-left">
                          <h4 class="mb-0"><?=$get_customers_inactive?></h4>
                          <small>Inactive Subscription</small>
                        </div>
                        <span class="badge bg-label-danger rounded-circle p-2">
                          <!--<i class="ti ti-user ti-md"></i>-->
                         <span class="material-symbols-outlined ">
                        unknown_document
                        </span>
                        </span>
                      </div>
                    </div>
                  </div>
                  </a>
                </div>
              </div>
            
            <h4>Employees</h4>
             
            <div class="row mb-4 g-3">
                <div class="col-xl-4">
                    <a href="<?php echo base_url('admin/register/employees');?>">
                  <div class="card">
                    <div class="card-body">
                      <div class="d-flex align-items-center justify-content-between">
                        <div class="content-left">
                          <h4 class="mb-0"><?=$get_employees?></h4>
                          <small>Employees</small>
                        </div>
                        <span class="badge bg-label-primary rounded-circle p-2">
                          <!--<i class="ti ti-currency-dollar ti-md"></i>-->
                           <span class="material-symbols-outlined">
                            group
                            </span>
                        </span>
                      </div>
                    </div>
                  </div>
                  </a>
                </div>
                <div class="col-xl-4">
                    <a href="<?php echo base_url('admin/register/employees');?>">
                  <div class="card">
                    <div class="card-body">
                      <div class="d-flex align-items-center justify-content-between">
                        <div class="content-left">
                          <h4 class="mb-0"><?=$get_employees_active?></h4>
                          <small>Active Employees </small>
                        </div>
                        <span class="badge bg-label-success rounded-circle p-2">
                          <!--<i class="ti ti-gift ti-md"></i>-->
                          <span class="material-symbols-outlined ">
                            unknown_document
                            </span>
                        </span>
                      </div>
                    </div>
                  </div>
                  </a>
                </div>
                <div class="col-xl-4">
                    <a href="<?php echo base_url('admin/register/employees');?>">
                  <div class="card">
                    <div class="card-body">
                      <div class="d-flex align-items-center justify-content-between">
                        <div class="content-left">
                          <h4 class="mb-0"><?=$get_employees_inactive?></h4>
                          <small>Inactive Employees</small>
                        </div>
                        <span class="badge bg-label-danger rounded-circle p-2">
                          <!--<i class="ti ti-user ti-md"></i>-->
                          <span class="material-symbols-outlined">
                            unknown_document
                            </span>
                        </span>
                      </div>
                    </div>
                  </div>
                  </a>
                </div>
              </div>
              
             <h4>Analytics</h4>
               <div class="row g-4">

    <!-- Active Users Report -->
    <div class="col-lg-6">
      <div class="card shadow-sm">
        <div class="card-body">
          <h6 class="text-muted">Active Users (Customer)</h6>
          <div id="chartActiveUsers"></div>
        </div>
      </div>
    </div>
    <div class="col-lg-6">
      <div class="card shadow-sm">
        <div class="card-body">
          <h6 class="text-muted">Active Users (Worker)</h6>
          <div id="chartActiveUsersworker"></div>
        </div>
      </div>
    </div>

    <!-- Session Report -->
    <div class="col-lg-6">
      <div class="card shadow-sm">
        <div class="card-body">
          <h6 class="text-muted">Sessions (Customer)</h6>
          <div id="chartSessions"></div>
        </div>
      </div>
    </div>
    
    <div class="col-lg-6">
      <div class="card shadow-sm">
        <div class="card-body">
          <h6 class="text-muted">Sessions (Worker)</h6>
          <div id="chartSessions_worker"></div>
        </div>
      </div>
    </div>

    <!-- Retention Report -->
    <div class="col-lg-6">
      <div class="card shadow-sm">
        <div class="card-body">
          <h6 class="text-muted">Retention (Customer)</h6>
          <div id="chartRetention"></div>
        </div>
      </div>
    </div>
    <div class="col-lg-6">
      <div class="card shadow-sm">
        <div class="card-body">
          <h6 class="text-muted">Retention (Worker)</h6>
          <div id="chartRetention_worker"></div>
        </div>
      </div>
    </div>

  </div>
  
  <script>
  var optionsActiveUsers = {
    chart: { type: 'bar', height: 250 },
    plotOptions: { bar: { horizontal: true, distributed: true, borderRadius: 4 } },
    series: [{
      data: [
        <?= $today_dau ?>,       // DAU
        <?= $current_mau ?>,     // MAU
        <?= $stickiness ?>       // Stickiness
      ]
    }],
    xaxis: { categories: [
      "DAU (<?= $today_dau ?>)",
      "MAU (<?= $current_mau ?>)",
      "Stickiness (<?= $stickiness ?>)"
    ]},
    colors: ['#28a745', '#007bff', '#ffc107']
  };

  new ApexCharts(document.querySelector("#chartActiveUsers"), optionsActiveUsers).render();
</script>

 <script>
  var optionsActiveUsersWorker = {
    chart: { type: 'bar', height: 250 },
    plotOptions: { bar: { horizontal: true, distributed: true, borderRadius: 4 } },
    series: [{
      data: [
        <?= $today_dau_w ?>,       // DAU
        <?= $current_mau_w ?>,     // MAU
        <?= $stickiness_w ?>       // Stickiness
      ]
    }],
    xaxis: { categories: [
      "DAU (<?= $today_dau_w ?>)",
      "MAU (<?= $current_mau_w ?>)",
      "Stickiness (<?= $stickiness_w ?>)"
    ]},
    colors: ['#28a745', '#007bff', '#ffc107']
  };

  new ApexCharts(document.querySelector("#chartActiveUsersworker"), optionsActiveUsersWorker).render();
</script>

<script>
<?php $median_depth = 0;?>
  var optionsSessions = {
    chart: { type: 'bar', height: 250 },
    plotOptions: { bar: { horizontal: true, distributed: true, borderRadius: 4 } },
    series: [{
      data: [
        <?= $current_mau_session ?>,   // Total Sessions
        <?= $avg_session ?>,         // Avg. Session Time
        <?= $median_depth ?>      // Median Depth
      ]
    }],
    xaxis: { categories: [
      "Total Sessions (<?= $current_mau_session ?>)",
      "Avg. Time (<?= $avg_session ?> min)",
      "Median Depth (<?= $median_depth ?> screens)"
    ]},
    colors: ['#17a2b8', '#6f42c1', '#fd7e14']
  };

  new ApexCharts(document.querySelector("#chartSessions"), optionsSessions).render();
</script>

<script>
<?php $median_depth_w = 0;?>
  var optionsSessions_worker = {
    chart: { type: 'bar', height: 250 },
    plotOptions: { bar: { horizontal: true, distributed: true, borderRadius: 4 } },
    series: [{
      data: [
        <?= $current_mau_session_w ?>,   // Total Sessions
        <?= $avg_session_w ?>,         // Avg. Session Time
        <?= $median_depth_w ?>      // Median Depth
      ]
    }],
    xaxis: { categories: [
      "Total Sessions (<?= $current_mau_session_w ?>)",
      "Avg. Time (<?= $avg_session_w ?> min)",
      "Median Depth (<?= $median_depth_w ?> screens)"
    ]},
    colors: ['#17a2b8', '#6f42c1', '#fd7e14']
  };

  new ApexCharts(document.querySelector("#chartSessions_worker"), optionsSessions_worker).render();
</script>



<script>
  var optionsRetention = {
    chart: { type: 'bar', height: 250 },
    plotOptions: { bar: { horizontal: true, distributed: true, borderRadius: 4 } },
    series: [{
      data: [
        <?= $retention['day1'] ?>,
        <?= $retention['day7'] ?>,
        <?= $retention['day30'] ?>
      ]
    }],
    xaxis: { categories: [
      "Day 1 (<?= $retention['day1'] ?>%)",
      "Day 7 (<?= $retention['day7'] ?>%)",
      "Day 30 (<?= $retention['day30'] ?>%)"
    ]},
    colors: ['#6610f2', '#20c997', '#dc3545']
  };

  new ApexCharts(document.querySelector("#chartRetention"), optionsRetention).render();
</script>
<script>
  var optionsRetention_worker = {
    chart: { type: 'bar', height: 250 },
    plotOptions: { bar: { horizontal: true, distributed: true, borderRadius: 4 } },
    series: [{
      data: [
        <?= $retention_w['day1'] ?>,
        <?= $retention_w['day7'] ?>,
        <?= $retention_w['day30'] ?>
      ]
    }],
    xaxis: { categories: [
      "Day 1 (<?= $retention_w['day1'] ?>%)",
      "Day 7 (<?= $retention_w['day7'] ?>%)",
      "Day 30 (<?= $retention_w['day30'] ?>%)"
    ]},
    colors: ['#6610f2', '#20c997', '#dc3545']
  };

  new ApexCharts(document.querySelector("#chartRetention_worker"), optionsRetention_worker).render();
</script>





<script>
  // Active Users (DAU, MAU, Stickiness)
//   var optionsActiveUsers = {
//     chart: { type: 'bar', height: 250 },
//     plotOptions: { bar: { horizontal: true, distributed: true, borderRadius: 4 } },
//     series: [{ data: [6200, 75000, 0.083] }],
//     xaxis: { categories: ['DAU (6,200 +8%)', 'MAU (75,000 +5%)', 'Stickiness (0.083 +0.01)'] },
//     colors: ['#28a745', '#007bff', '#ffc107']
//   };
//   new ApexCharts(document.querySelector("#chartActiveUsers"), optionsActiveUsers).render();

  // Sessions (Total, Avg. Time, Depth)
//   var optionsSessions = {
//     chart: { type: 'bar', height: 250 },
//     plotOptions: { bar: { horizontal: true, distributed: true, borderRadius: 4 } },
//     series: [{ data: [180000, 14.2, 7] }],
//     xaxis: { categories: ['Total Sessions (180k +6%)', 'Avg. Time (14.2 min +9%)', 'Median Depth (7 +1)'] },
//     colors: ['#17a2b8', '#6f42c1', '#fd7e14']
//   };
//   new ApexCharts(document.querySelector("#chartSessions"), optionsSessions).render();

  // Retention (Day 1, Day 7, Day 30)
//   var optionsRetention = {
//     chart: { type: 'bar', height: 250 },
//     plotOptions: { bar: { horizontal: true, distributed: true, borderRadius: 4 } },
//     series: [{ data: [48, 32, 25] }],
//     xaxis: { categories: ['Day 1 (48%)', 'Day 7 (32%)', 'Day 30 (25%)'] },
//     colors: ['#6610f2', '#20c997', '#dc3545']
//   };
//   new ApexCharts(document.querySelector("#chartRetention"), optionsRetention).render();
</script>



            
          </div>
          

          