<?php
defined('BASEPATH') OR exit('No direct script access allowed');
//define('KEY','AAAAlwr9C0g:APA91bGDvCkePC2E__03Jm6U3Jz8046DyZN4I-NlwisBhxT0GgpesJ1ZXLvdz5EqeR58Q8f0_Af-tpclYU7X1Eo4FHm34nzXUnrifgLoeFDMtjH77FoxvkHICFWQFt04Az5riiDtIalW');
class Check_subscription extends CI_Controller {
    function __construct()
	{
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
		$this->load->library(array('form_validation', 'session'));
		$this->load->helper('url','form','HTML');
		$this->load->library('Notifications');
		//$this->is_logged_in();
		$this->load->model('admin/registermodel');
		$this->db->query('SET SESSION sql_mode =
                  REPLACE(REPLACE(REPLACE(
                  @@sql_mode,
                  "ONLY_FULL_GROUP_BY,", ""),
                  ",ONLY_FULL_GROUP_BY", ""),
                  "ONLY_FULL_GROUP_BY", "")'); 
	}
	
	

/*access token*/
public function getAccessToken(){
    $serviceAccountFile = FCPATH . 'application/libraries/firebase.json'; // Update this path
    $jsonKey = json_decode(file_get_contents($serviceAccountFile), true);

    $header = json_encode(['alg' => 'RS256', 'typ' => 'JWT']);
    $now = time();
    $exp = $now + 3600;

    $payload = json_encode([
        'iss' => $jsonKey['client_email'],
        'sub' => $jsonKey['client_email'],
        'aud' => 'https://oauth2.googleapis.com/token',
        'iat' => $now,
        'exp' => $exp,
        'scope' => 'https://www.googleapis.com/auth/firebase.messaging'
    ]);

    $base64UrlHeader = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($header));
    $base64UrlPayload = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($payload));
    $signature = '';

    $data = $base64UrlHeader . '.' . $base64UrlPayload;
    openssl_sign($data, $signature, $jsonKey['private_key'], 'sha256');

    $base64UrlSignature = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($signature));
    $jwt = $data . '.' . $base64UrlSignature;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://oauth2.googleapis.com/token');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
        'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer',
        'assertion' => $jwt
    ]));

    $response = curl_exec($ch);
    if (curl_errno($ch)) {
        echo 'Curl error: ' . curl_error($ch);
    }
    curl_close($ch);

    $responseData = json_decode($response, true);
    //print_r($responseData);exit;
    if (isset($responseData['access_token'])) {
        return $responseData['access_token'];
    } else {
        echo 'Error fetching access token: ' . $response;
        return null;
    }
        
}
/*access token*/
	
/*check subscription*/
public function check_subscription(){
    $i=0;
    $get_users = $this->registermodel->common_fetch('users',['to_date>=' => date('Y-m-d'),'status' => 1]);
    //echo $this->db->last_query();exit;
    if(!empty($get_users)){
        //echo '<pre>';
        //print_r($get_users);
        //echo '</pre>';exit;
        foreach($get_users as $row){
            $to_date = $row['to_date'];
            
            
            $date1 = date('Y-m-d');
            $date2 = $to_date;
            
            $diff = abs(strtotime($date2) - strtotime($date1));
            
            $years = floor($diff / (365*60*60*24));
            $months = floor(($diff - $years * 365*60*60*24) / (30*60*60*24));
            $days = floor(($diff - $years * 365*60*60*24 - $months*30*60*60*24)/ (60*60*24));
            
            if($days<=7){
                $data = array(
                   'member_id'          => $row['id'],
        	       'title'              => 'Kaamhaina',
                   'message'            => 'Dear User, Your subscription plan will end in '.$days.' days, please renewal to access our services',           
        		   'created_on'	        => date('Y-m-d')
        		);
               $message = array();
               $message['title'] = $data['title'];
               $message['body'] = $data['message'];
               $access_token = $this->getAccessToken();
               $daa = $this->notifications->sendFCM($access_token,$message,$row['token']);
               //print_r($daa);
               $insert_notifications = $this->registermodel->common_insert('notifications',$data);
            }
            
            //printf($days);
            
            
            
            
            $i++;
        }exit;
    }
}
/*check subscription*/


}